<?php

namespace Common\Core\Install;

use Common\Settings\Setting;
use Illuminate\Support\Arr;
use Illuminate\Support\Str;

class CreateDefaultMenus
{
    public function execute(): void
    {
        if (Setting::where('name', 'menus')->exists()) {
            throw new \Exception('Menus already exist');
        }

        $menus = json_decode(
            Arr::first(
                config('common.default-settings'),
                fn($value) => $value['name'] === 'menus',
            )['value'],
            true,
        );

        foreach ($menus as $menuIndex => $menu) {
            if (!isset($menu['id'])) {
                $menu[$menuIndex]['id'] = Str::random(6);
            }
            foreach ($menu['items'] as $itemIndex => $item) {
                if (!isset($item['id'])) {
                    $menus[$menuIndex]['items'][$itemIndex]['id'] = Str::random(
                        6,
                    );
                }
                if (!isset($item['order'])) {
                    $menus[$menuIndex]['items'][$itemIndex][
                        'order'
                    ] = $itemIndex;
                }
            }
        }

        Setting::create([
            'name' => 'menus',
            'value' => json_encode($menus),
        ]);
    }
}
