<?php
/**
 * TranscriptionVocabulariesApi
 * PHP version 7.2
 *
 * @category Class
 * @package  MuxPhp
 * @author   Mux API team
 * @link     https://docs.mux.com
 */

/**
 * Mux API
 *
 * Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.
 *
 * The version of the OpenAPI document: v1
 * Contact: devex@mux.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace MuxPhp\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use MuxPhp\ApiException;
use MuxPhp\Configuration;
use MuxPhp\HeaderSelector;
use MuxPhp\ObjectSerializer;

/**
 * TranscriptionVocabulariesApi Class Doc Comment
 *
 * @category Class
 * @package  MuxPhp
 * @author   Mux API team
 * @link     https://docs.mux.com
 */
class TranscriptionVocabulariesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex)
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createTranscriptionVocabulary
     *
     * Create a Transcription Vocabulary
     *
     * @param  \MuxPhp\Models\CreateTranscriptionVocabularyRequest $create_transcription_vocabulary_request create_transcription_vocabulary_request (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MuxPhp\Models\TranscriptionVocabularyResponse
     */
    public function createTranscriptionVocabulary($create_transcription_vocabulary_request)
    {
        list($response) = $this->createTranscriptionVocabularyWithHttpInfo($create_transcription_vocabulary_request);
        return $response;
    }

    /**
     * Operation createTranscriptionVocabularyWithHttpInfo
     *
     * Create a Transcription Vocabulary
     *
     * @param  \MuxPhp\Models\CreateTranscriptionVocabularyRequest $create_transcription_vocabulary_request (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MuxPhp\Models\TranscriptionVocabularyResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTranscriptionVocabularyWithHttpInfo($create_transcription_vocabulary_request)
    {
        $request = $this->createTranscriptionVocabularyRequest($create_transcription_vocabulary_request);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 201:
                    if ('\MuxPhp\Models\TranscriptionVocabularyResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MuxPhp\Models\TranscriptionVocabularyResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MuxPhp\Models\TranscriptionVocabularyResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MuxPhp\Models\TranscriptionVocabularyResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createTranscriptionVocabularyAsync
     *
     * Create a Transcription Vocabulary
     *
     * @param  \MuxPhp\Models\CreateTranscriptionVocabularyRequest $create_transcription_vocabulary_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTranscriptionVocabularyAsync($create_transcription_vocabulary_request)
    {
        return $this->createTranscriptionVocabularyAsyncWithHttpInfo($create_transcription_vocabulary_request)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createTranscriptionVocabularyAsyncWithHttpInfo
     *
     * Create a Transcription Vocabulary
     *
     * @param  \MuxPhp\Models\CreateTranscriptionVocabularyRequest $create_transcription_vocabulary_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTranscriptionVocabularyAsyncWithHttpInfo($create_transcription_vocabulary_request)
    {
        $returnType = '\MuxPhp\Models\TranscriptionVocabularyResponse';
        $request = $this->createTranscriptionVocabularyRequest($create_transcription_vocabulary_request);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createTranscriptionVocabulary'
     *
     * @param  \MuxPhp\Models\CreateTranscriptionVocabularyRequest $create_transcription_vocabulary_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createTranscriptionVocabularyRequest($create_transcription_vocabulary_request)
    {
        // verify the required parameter 'create_transcription_vocabulary_request' is set
        if ($create_transcription_vocabulary_request === null || (is_array($create_transcription_vocabulary_request) && count($create_transcription_vocabulary_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_transcription_vocabulary_request when calling createTranscriptionVocabulary'
            );
        }

        $resourcePath = '/video/v1/transcription-vocabularies';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($create_transcription_vocabulary_request)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($create_transcription_vocabulary_request));
            } else {
                $httpBody = $create_transcription_vocabulary_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );


        // MUX: adds support for array params.
        // TODO: future upstream?
        $query = ObjectSerializer::buildBetterQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteTranscriptionVocabulary
     *
     * Delete a Transcription Vocabulary
     *
     * @param  string $transcription_vocabulary_id The ID of the Transcription Vocabulary. (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteTranscriptionVocabulary($transcription_vocabulary_id)
    {
        $this->deleteTranscriptionVocabularyWithHttpInfo($transcription_vocabulary_id);
    }

    /**
     * Operation deleteTranscriptionVocabularyWithHttpInfo
     *
     * Delete a Transcription Vocabulary
     *
     * @param  string $transcription_vocabulary_id The ID of the Transcription Vocabulary. (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTranscriptionVocabularyWithHttpInfo($transcription_vocabulary_id)
    {
        $request = $this->deleteTranscriptionVocabularyRequest($transcription_vocabulary_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteTranscriptionVocabularyAsync
     *
     * Delete a Transcription Vocabulary
     *
     * @param  string $transcription_vocabulary_id The ID of the Transcription Vocabulary. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteTranscriptionVocabularyAsync($transcription_vocabulary_id)
    {
        return $this->deleteTranscriptionVocabularyAsyncWithHttpInfo($transcription_vocabulary_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteTranscriptionVocabularyAsyncWithHttpInfo
     *
     * Delete a Transcription Vocabulary
     *
     * @param  string $transcription_vocabulary_id The ID of the Transcription Vocabulary. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteTranscriptionVocabularyAsyncWithHttpInfo($transcription_vocabulary_id)
    {
        $returnType = '';
        $request = $this->deleteTranscriptionVocabularyRequest($transcription_vocabulary_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteTranscriptionVocabulary'
     *
     * @param  string $transcription_vocabulary_id The ID of the Transcription Vocabulary. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteTranscriptionVocabularyRequest($transcription_vocabulary_id)
    {
        // verify the required parameter 'transcription_vocabulary_id' is set
        if ($transcription_vocabulary_id === null || (is_array($transcription_vocabulary_id) && count($transcription_vocabulary_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $transcription_vocabulary_id when calling deleteTranscriptionVocabulary'
            );
        }

        $resourcePath = '/video/v1/transcription-vocabularies/{TRANSCRIPTION_VOCABULARY_ID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($transcription_vocabulary_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TRANSCRIPTION_VOCABULARY_ID' . '}',
                ObjectSerializer::toPathValue($transcription_vocabulary_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );


        // MUX: adds support for array params.
        // TODO: future upstream?
        $query = ObjectSerializer::buildBetterQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getTranscriptionVocabulary
     *
     * Retrieve a Transcription Vocabulary
     *
     * @param  string $transcription_vocabulary_id The ID of the Transcription Vocabulary. (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MuxPhp\Models\TranscriptionVocabularyResponse
     */
    public function getTranscriptionVocabulary($transcription_vocabulary_id)
    {
        list($response) = $this->getTranscriptionVocabularyWithHttpInfo($transcription_vocabulary_id);
        return $response;
    }

    /**
     * Operation getTranscriptionVocabularyWithHttpInfo
     *
     * Retrieve a Transcription Vocabulary
     *
     * @param  string $transcription_vocabulary_id The ID of the Transcription Vocabulary. (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MuxPhp\Models\TranscriptionVocabularyResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTranscriptionVocabularyWithHttpInfo($transcription_vocabulary_id)
    {
        $request = $this->getTranscriptionVocabularyRequest($transcription_vocabulary_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\MuxPhp\Models\TranscriptionVocabularyResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MuxPhp\Models\TranscriptionVocabularyResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MuxPhp\Models\TranscriptionVocabularyResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MuxPhp\Models\TranscriptionVocabularyResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getTranscriptionVocabularyAsync
     *
     * Retrieve a Transcription Vocabulary
     *
     * @param  string $transcription_vocabulary_id The ID of the Transcription Vocabulary. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTranscriptionVocabularyAsync($transcription_vocabulary_id)
    {
        return $this->getTranscriptionVocabularyAsyncWithHttpInfo($transcription_vocabulary_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getTranscriptionVocabularyAsyncWithHttpInfo
     *
     * Retrieve a Transcription Vocabulary
     *
     * @param  string $transcription_vocabulary_id The ID of the Transcription Vocabulary. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTranscriptionVocabularyAsyncWithHttpInfo($transcription_vocabulary_id)
    {
        $returnType = '\MuxPhp\Models\TranscriptionVocabularyResponse';
        $request = $this->getTranscriptionVocabularyRequest($transcription_vocabulary_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getTranscriptionVocabulary'
     *
     * @param  string $transcription_vocabulary_id The ID of the Transcription Vocabulary. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getTranscriptionVocabularyRequest($transcription_vocabulary_id)
    {
        // verify the required parameter 'transcription_vocabulary_id' is set
        if ($transcription_vocabulary_id === null || (is_array($transcription_vocabulary_id) && count($transcription_vocabulary_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $transcription_vocabulary_id when calling getTranscriptionVocabulary'
            );
        }

        $resourcePath = '/video/v1/transcription-vocabularies/{TRANSCRIPTION_VOCABULARY_ID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($transcription_vocabulary_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TRANSCRIPTION_VOCABULARY_ID' . '}',
                ObjectSerializer::toPathValue($transcription_vocabulary_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );


        // MUX: adds support for array params.
        // TODO: future upstream?
        $query = ObjectSerializer::buildBetterQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listTranscriptionVocabularies
     *
     * List Transcription Vocabularies
     *
     * @param  int $limit Number of items to include in the response (optional, default to 10)
     * @param  int $page Offset by this many pages, of the size of &#x60;limit&#x60; (optional, default to 1)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MuxPhp\Models\ListTranscriptionVocabulariesResponse
     */
    public function listTranscriptionVocabularies($limit = 10, $page = 1)
    {
        list($response) = $this->listTranscriptionVocabulariesWithHttpInfo($limit, $page);
        return $response;
    }

    /**
     * Operation listTranscriptionVocabulariesWithHttpInfo
     *
     * List Transcription Vocabularies
     *
     * @param  int $limit Number of items to include in the response (optional, default to 10)
     * @param  int $page Offset by this many pages, of the size of &#x60;limit&#x60; (optional, default to 1)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MuxPhp\Models\ListTranscriptionVocabulariesResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function listTranscriptionVocabulariesWithHttpInfo($limit = 10, $page = 1)
    {
        $request = $this->listTranscriptionVocabulariesRequest($limit, $page);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\MuxPhp\Models\ListTranscriptionVocabulariesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MuxPhp\Models\ListTranscriptionVocabulariesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MuxPhp\Models\ListTranscriptionVocabulariesResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MuxPhp\Models\ListTranscriptionVocabulariesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listTranscriptionVocabulariesAsync
     *
     * List Transcription Vocabularies
     *
     * @param  int $limit Number of items to include in the response (optional, default to 10)
     * @param  int $page Offset by this many pages, of the size of &#x60;limit&#x60; (optional, default to 1)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listTranscriptionVocabulariesAsync($limit = 10, $page = 1)
    {
        return $this->listTranscriptionVocabulariesAsyncWithHttpInfo($limit, $page)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listTranscriptionVocabulariesAsyncWithHttpInfo
     *
     * List Transcription Vocabularies
     *
     * @param  int $limit Number of items to include in the response (optional, default to 10)
     * @param  int $page Offset by this many pages, of the size of &#x60;limit&#x60; (optional, default to 1)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listTranscriptionVocabulariesAsyncWithHttpInfo($limit = 10, $page = 1)
    {
        $returnType = '\MuxPhp\Models\ListTranscriptionVocabulariesResponse';
        $request = $this->listTranscriptionVocabulariesRequest($limit, $page);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listTranscriptionVocabularies'
     *
     * @param  int $limit Number of items to include in the response (optional, default to 10)
     * @param  int $page Offset by this many pages, of the size of &#x60;limit&#x60; (optional, default to 1)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listTranscriptionVocabulariesRequest($limit = 10, $page = 1)
    {
        if ($limit !== null && $limit > 10) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling TranscriptionVocabulariesApi.listTranscriptionVocabularies, must be smaller than or equal to 10.');
        }


        $resourcePath = '/video/v1/transcription-vocabularies';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($limit !== null) {
            if('form' === 'form' && is_array($limit)) {
                foreach($limit as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['limit'] = $limit;
            }
        }
        // query params
        if ($page !== null) {
            if('form' === 'form' && is_array($page)) {
                foreach($page as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['page'] = $page;
            }
        }




        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );


        // MUX: adds support for array params.
        // TODO: future upstream?
        $query = ObjectSerializer::buildBetterQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateTranscriptionVocabulary
     *
     * Update a Transcription Vocabulary
     *
     * @param  string $transcription_vocabulary_id The ID of the Transcription Vocabulary. (required)
     * @param  \MuxPhp\Models\UpdateTranscriptionVocabularyRequest $update_transcription_vocabulary_request update_transcription_vocabulary_request (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MuxPhp\Models\TranscriptionVocabularyResponse
     */
    public function updateTranscriptionVocabulary($transcription_vocabulary_id, $update_transcription_vocabulary_request)
    {
        list($response) = $this->updateTranscriptionVocabularyWithHttpInfo($transcription_vocabulary_id, $update_transcription_vocabulary_request);
        return $response;
    }

    /**
     * Operation updateTranscriptionVocabularyWithHttpInfo
     *
     * Update a Transcription Vocabulary
     *
     * @param  string $transcription_vocabulary_id The ID of the Transcription Vocabulary. (required)
     * @param  \MuxPhp\Models\UpdateTranscriptionVocabularyRequest $update_transcription_vocabulary_request (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MuxPhp\Models\TranscriptionVocabularyResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateTranscriptionVocabularyWithHttpInfo($transcription_vocabulary_id, $update_transcription_vocabulary_request)
    {
        $request = $this->updateTranscriptionVocabularyRequest($transcription_vocabulary_id, $update_transcription_vocabulary_request);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\MuxPhp\Models\TranscriptionVocabularyResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MuxPhp\Models\TranscriptionVocabularyResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MuxPhp\Models\TranscriptionVocabularyResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MuxPhp\Models\TranscriptionVocabularyResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateTranscriptionVocabularyAsync
     *
     * Update a Transcription Vocabulary
     *
     * @param  string $transcription_vocabulary_id The ID of the Transcription Vocabulary. (required)
     * @param  \MuxPhp\Models\UpdateTranscriptionVocabularyRequest $update_transcription_vocabulary_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateTranscriptionVocabularyAsync($transcription_vocabulary_id, $update_transcription_vocabulary_request)
    {
        return $this->updateTranscriptionVocabularyAsyncWithHttpInfo($transcription_vocabulary_id, $update_transcription_vocabulary_request)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateTranscriptionVocabularyAsyncWithHttpInfo
     *
     * Update a Transcription Vocabulary
     *
     * @param  string $transcription_vocabulary_id The ID of the Transcription Vocabulary. (required)
     * @param  \MuxPhp\Models\UpdateTranscriptionVocabularyRequest $update_transcription_vocabulary_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateTranscriptionVocabularyAsyncWithHttpInfo($transcription_vocabulary_id, $update_transcription_vocabulary_request)
    {
        $returnType = '\MuxPhp\Models\TranscriptionVocabularyResponse';
        $request = $this->updateTranscriptionVocabularyRequest($transcription_vocabulary_id, $update_transcription_vocabulary_request);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateTranscriptionVocabulary'
     *
     * @param  string $transcription_vocabulary_id The ID of the Transcription Vocabulary. (required)
     * @param  \MuxPhp\Models\UpdateTranscriptionVocabularyRequest $update_transcription_vocabulary_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateTranscriptionVocabularyRequest($transcription_vocabulary_id, $update_transcription_vocabulary_request)
    {
        // verify the required parameter 'transcription_vocabulary_id' is set
        if ($transcription_vocabulary_id === null || (is_array($transcription_vocabulary_id) && count($transcription_vocabulary_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $transcription_vocabulary_id when calling updateTranscriptionVocabulary'
            );
        }
        // verify the required parameter 'update_transcription_vocabulary_request' is set
        if ($update_transcription_vocabulary_request === null || (is_array($update_transcription_vocabulary_request) && count($update_transcription_vocabulary_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_transcription_vocabulary_request when calling updateTranscriptionVocabulary'
            );
        }

        $resourcePath = '/video/v1/transcription-vocabularies/{TRANSCRIPTION_VOCABULARY_ID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($transcription_vocabulary_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TRANSCRIPTION_VOCABULARY_ID' . '}',
                ObjectSerializer::toPathValue($transcription_vocabulary_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($update_transcription_vocabulary_request)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($update_transcription_vocabulary_request));
            } else {
                $httpBody = $update_transcription_vocabulary_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );


        // MUX: adds support for array params.
        // TODO: future upstream?
        $query = ObjectSerializer::buildBetterQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
