<?php
/**
 * Incident
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  MuxPhp
 * @author   Mux API team
 * @link     https://docs.mux.com
 */

/**
 * Mux API
 *
 * Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.
 *
 * The version of the OpenAPI document: v1
 * Contact: devex@mux.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace MuxPhp\Models;

use \ArrayAccess;
use \MuxPhp\ObjectSerializer;

/**
 * Incident Class Doc Comment
 *
 * @category Class
 * @package  MuxPhp
 * @author   Mux API team
 * @link     https://docs.mux.com
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class Incident implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Incident';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'threshold' => 'double',
        'status' => 'string',
        'started_at' => 'string',
        'severity' => 'string',
        'sample_size_unit' => 'string',
        'sample_size' => 'int',
        'resolved_at' => 'string',
        'notifications' => '\MuxPhp\Models\IncidentNotification[]',
        'notification_rules' => '\MuxPhp\Models\IncidentNotificationRule[]',
        'measurement' => 'string',
        'measured_value_on_close' => 'double',
        'measured_value' => 'double',
        'incident_key' => 'string',
        'impact' => 'string',
        'id' => 'string',
        'error_description' => 'string',
        'description' => 'string',
        'breakdowns' => '\MuxPhp\Models\IncidentBreakdown[]',
        'affected_views_per_hour_on_open' => 'int',
        'affected_views_per_hour' => 'int',
        'affected_views' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'threshold' => 'double',
        'status' => null,
        'started_at' => null,
        'severity' => null,
        'sample_size_unit' => null,
        'sample_size' => 'int64',
        'resolved_at' => null,
        'notifications' => null,
        'notification_rules' => null,
        'measurement' => null,
        'measured_value_on_close' => 'double',
        'measured_value' => 'double',
        'incident_key' => null,
        'impact' => null,
        'id' => null,
        'error_description' => null,
        'description' => null,
        'breakdowns' => null,
        'affected_views_per_hour_on_open' => 'int64',
        'affected_views_per_hour' => 'int64',
        'affected_views' => 'int64'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'threshold' => false,
        'status' => false,
        'started_at' => false,
        'severity' => false,
        'sample_size_unit' => false,
        'sample_size' => false,
        'resolved_at' => true,
        'notifications' => false,
        'notification_rules' => false,
        'measurement' => false,
        'measured_value_on_close' => true,
        'measured_value' => true,
        'incident_key' => false,
        'impact' => false,
        'id' => false,
        'error_description' => false,
        'description' => false,
        'breakdowns' => false,
        'affected_views_per_hour_on_open' => false,
        'affected_views_per_hour' => false,
        'affected_views' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'threshold' => 'threshold',
        'status' => 'status',
        'started_at' => 'started_at',
        'severity' => 'severity',
        'sample_size_unit' => 'sample_size_unit',
        'sample_size' => 'sample_size',
        'resolved_at' => 'resolved_at',
        'notifications' => 'notifications',
        'notification_rules' => 'notification_rules',
        'measurement' => 'measurement',
        'measured_value_on_close' => 'measured_value_on_close',
        'measured_value' => 'measured_value',
        'incident_key' => 'incident_key',
        'impact' => 'impact',
        'id' => 'id',
        'error_description' => 'error_description',
        'description' => 'description',
        'breakdowns' => 'breakdowns',
        'affected_views_per_hour_on_open' => 'affected_views_per_hour_on_open',
        'affected_views_per_hour' => 'affected_views_per_hour',
        'affected_views' => 'affected_views'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'threshold' => 'setThreshold',
        'status' => 'setStatus',
        'started_at' => 'setStartedAt',
        'severity' => 'setSeverity',
        'sample_size_unit' => 'setSampleSizeUnit',
        'sample_size' => 'setSampleSize',
        'resolved_at' => 'setResolvedAt',
        'notifications' => 'setNotifications',
        'notification_rules' => 'setNotificationRules',
        'measurement' => 'setMeasurement',
        'measured_value_on_close' => 'setMeasuredValueOnClose',
        'measured_value' => 'setMeasuredValue',
        'incident_key' => 'setIncidentKey',
        'impact' => 'setImpact',
        'id' => 'setId',
        'error_description' => 'setErrorDescription',
        'description' => 'setDescription',
        'breakdowns' => 'setBreakdowns',
        'affected_views_per_hour_on_open' => 'setAffectedViewsPerHourOnOpen',
        'affected_views_per_hour' => 'setAffectedViewsPerHour',
        'affected_views' => 'setAffectedViews'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'threshold' => 'getThreshold',
        'status' => 'getStatus',
        'started_at' => 'getStartedAt',
        'severity' => 'getSeverity',
        'sample_size_unit' => 'getSampleSizeUnit',
        'sample_size' => 'getSampleSize',
        'resolved_at' => 'getResolvedAt',
        'notifications' => 'getNotifications',
        'notification_rules' => 'getNotificationRules',
        'measurement' => 'getMeasurement',
        'measured_value_on_close' => 'getMeasuredValueOnClose',
        'measured_value' => 'getMeasuredValue',
        'incident_key' => 'getIncidentKey',
        'impact' => 'getImpact',
        'id' => 'getId',
        'error_description' => 'getErrorDescription',
        'description' => 'getDescription',
        'breakdowns' => 'getBreakdowns',
        'affected_views_per_hour_on_open' => 'getAffectedViewsPerHourOnOpen',
        'affected_views_per_hour' => 'getAffectedViewsPerHour',
        'affected_views' => 'getAffectedViews'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        // MUX: enum hack (self::) due to OAS emitting problems.
        //      please re-integrate with mainline when possible.
        //      src: https://github.com/OpenAPITools/openapi-generator/issues/9038
        $this->setIfExists('threshold', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('started_at', $data ?? [], null);
        $this->setIfExists('severity', $data ?? [], null);
        $this->setIfExists('sample_size_unit', $data ?? [], null);
        $this->setIfExists('sample_size', $data ?? [], null);
        $this->setIfExists('resolved_at', $data ?? [], null);
        $this->setIfExists('notifications', $data ?? [], null);
        $this->setIfExists('notification_rules', $data ?? [], null);
        $this->setIfExists('measurement', $data ?? [], null);
        $this->setIfExists('measured_value_on_close', $data ?? [], null);
        $this->setIfExists('measured_value', $data ?? [], null);
        $this->setIfExists('incident_key', $data ?? [], null);
        $this->setIfExists('impact', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('error_description', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('breakdowns', $data ?? [], null);
        $this->setIfExists('affected_views_per_hour_on_open', $data ?? [], null);
        $this->setIfExists('affected_views_per_hour', $data ?? [], null);
        $this->setIfExists('affected_views', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets threshold
     *
     * @return double|null
     */
    public function getThreshold()
    {
        return $this->container['threshold'];
    }

    /**
     * Sets threshold
     *
     * @param double|null $threshold threshold
     *
     * @return self
     */
    public function setThreshold($threshold)
    {

        if (is_null($threshold)) {
            throw new \InvalidArgumentException('non-nullable threshold cannot be null');
        }

        $this->container['threshold'] = $threshold;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status status
     *
     * @return self
     */
    public function setStatus($status)
    {

        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }

        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets started_at
     *
     * @return string|null
     */
    public function getStartedAt()
    {
        return $this->container['started_at'];
    }

    /**
     * Sets started_at
     *
     * @param string|null $started_at started_at
     *
     * @return self
     */
    public function setStartedAt($started_at)
    {

        if (is_null($started_at)) {
            throw new \InvalidArgumentException('non-nullable started_at cannot be null');
        }

        $this->container['started_at'] = $started_at;

        return $this;
    }

    /**
     * Gets severity
     *
     * @return string|null
     */
    public function getSeverity()
    {
        return $this->container['severity'];
    }

    /**
     * Sets severity
     *
     * @param string|null $severity severity
     *
     * @return self
     */
    public function setSeverity($severity)
    {

        if (is_null($severity)) {
            throw new \InvalidArgumentException('non-nullable severity cannot be null');
        }

        $this->container['severity'] = $severity;

        return $this;
    }

    /**
     * Gets sample_size_unit
     *
     * @return string|null
     */
    public function getSampleSizeUnit()
    {
        return $this->container['sample_size_unit'];
    }

    /**
     * Sets sample_size_unit
     *
     * @param string|null $sample_size_unit sample_size_unit
     *
     * @return self
     */
    public function setSampleSizeUnit($sample_size_unit)
    {

        if (is_null($sample_size_unit)) {
            throw new \InvalidArgumentException('non-nullable sample_size_unit cannot be null');
        }

        $this->container['sample_size_unit'] = $sample_size_unit;

        return $this;
    }

    /**
     * Gets sample_size
     *
     * @return int|null
     */
    public function getSampleSize()
    {
        return $this->container['sample_size'];
    }

    /**
     * Sets sample_size
     *
     * @param int|null $sample_size sample_size
     *
     * @return self
     */
    public function setSampleSize($sample_size)
    {

        if (is_null($sample_size)) {
            throw new \InvalidArgumentException('non-nullable sample_size cannot be null');
        }

        $this->container['sample_size'] = $sample_size;

        return $this;
    }

    /**
     * Gets resolved_at
     *
     * @return string|null
     */
    public function getResolvedAt()
    {
        return $this->container['resolved_at'];
    }

    /**
     * Sets resolved_at
     *
     * @param string|null $resolved_at resolved_at
     *
     * @return self
     */
    public function setResolvedAt($resolved_at)
    {

        if (is_null($resolved_at)) {
            array_push($this->openAPINullablesSetToNull, 'resolved_at');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('resolved_at', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['resolved_at'] = $resolved_at;

        return $this;
    }

    /**
     * Gets notifications
     *
     * @return \MuxPhp\Models\IncidentNotification[]|null
     */
    public function getNotifications()
    {
        return $this->container['notifications'];
    }

    /**
     * Sets notifications
     *
     * @param \MuxPhp\Models\IncidentNotification[]|null $notifications notifications
     *
     * @return self
     */
    public function setNotifications($notifications)
    {

        if (is_null($notifications)) {
            throw new \InvalidArgumentException('non-nullable notifications cannot be null');
        }

        $this->container['notifications'] = $notifications;

        return $this;
    }

    /**
     * Gets notification_rules
     *
     * @return \MuxPhp\Models\IncidentNotificationRule[]|null
     */
    public function getNotificationRules()
    {
        return $this->container['notification_rules'];
    }

    /**
     * Sets notification_rules
     *
     * @param \MuxPhp\Models\IncidentNotificationRule[]|null $notification_rules notification_rules
     *
     * @return self
     */
    public function setNotificationRules($notification_rules)
    {

        if (is_null($notification_rules)) {
            throw new \InvalidArgumentException('non-nullable notification_rules cannot be null');
        }

        $this->container['notification_rules'] = $notification_rules;

        return $this;
    }

    /**
     * Gets measurement
     *
     * @return string|null
     */
    public function getMeasurement()
    {
        return $this->container['measurement'];
    }

    /**
     * Sets measurement
     *
     * @param string|null $measurement measurement
     *
     * @return self
     */
    public function setMeasurement($measurement)
    {

        if (is_null($measurement)) {
            throw new \InvalidArgumentException('non-nullable measurement cannot be null');
        }

        $this->container['measurement'] = $measurement;

        return $this;
    }

    /**
     * Gets measured_value_on_close
     *
     * @return double|null
     */
    public function getMeasuredValueOnClose()
    {
        return $this->container['measured_value_on_close'];
    }

    /**
     * Sets measured_value_on_close
     *
     * @param double|null $measured_value_on_close measured_value_on_close
     *
     * @return self
     */
    public function setMeasuredValueOnClose($measured_value_on_close)
    {

        if (is_null($measured_value_on_close)) {
            array_push($this->openAPINullablesSetToNull, 'measured_value_on_close');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('measured_value_on_close', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['measured_value_on_close'] = $measured_value_on_close;

        return $this;
    }

    /**
     * Gets measured_value
     *
     * @return double|null
     */
    public function getMeasuredValue()
    {
        return $this->container['measured_value'];
    }

    /**
     * Sets measured_value
     *
     * @param double|null $measured_value measured_value
     *
     * @return self
     */
    public function setMeasuredValue($measured_value)
    {

        if (is_null($measured_value)) {
            array_push($this->openAPINullablesSetToNull, 'measured_value');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('measured_value', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['measured_value'] = $measured_value;

        return $this;
    }

    /**
     * Gets incident_key
     *
     * @return string|null
     */
    public function getIncidentKey()
    {
        return $this->container['incident_key'];
    }

    /**
     * Sets incident_key
     *
     * @param string|null $incident_key incident_key
     *
     * @return self
     */
    public function setIncidentKey($incident_key)
    {

        if (is_null($incident_key)) {
            throw new \InvalidArgumentException('non-nullable incident_key cannot be null');
        }

        $this->container['incident_key'] = $incident_key;

        return $this;
    }

    /**
     * Gets impact
     *
     * @return string|null
     */
    public function getImpact()
    {
        return $this->container['impact'];
    }

    /**
     * Sets impact
     *
     * @param string|null $impact impact
     *
     * @return self
     */
    public function setImpact($impact)
    {

        if (is_null($impact)) {
            throw new \InvalidArgumentException('non-nullable impact cannot be null');
        }

        $this->container['impact'] = $impact;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id id
     *
     * @return self
     */
    public function setId($id)
    {

        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }

        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets error_description
     *
     * @return string|null
     */
    public function getErrorDescription()
    {
        return $this->container['error_description'];
    }

    /**
     * Sets error_description
     *
     * @param string|null $error_description error_description
     *
     * @return self
     */
    public function setErrorDescription($error_description)
    {

        if (is_null($error_description)) {
            throw new \InvalidArgumentException('non-nullable error_description cannot be null');
        }

        $this->container['error_description'] = $error_description;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description description
     *
     * @return self
     */
    public function setDescription($description)
    {

        if (is_null($description)) {
            throw new \InvalidArgumentException('non-nullable description cannot be null');
        }

        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets breakdowns
     *
     * @return \MuxPhp\Models\IncidentBreakdown[]|null
     */
    public function getBreakdowns()
    {
        return $this->container['breakdowns'];
    }

    /**
     * Sets breakdowns
     *
     * @param \MuxPhp\Models\IncidentBreakdown[]|null $breakdowns breakdowns
     *
     * @return self
     */
    public function setBreakdowns($breakdowns)
    {

        if (is_null($breakdowns)) {
            throw new \InvalidArgumentException('non-nullable breakdowns cannot be null');
        }

        $this->container['breakdowns'] = $breakdowns;

        return $this;
    }

    /**
     * Gets affected_views_per_hour_on_open
     *
     * @return int|null
     */
    public function getAffectedViewsPerHourOnOpen()
    {
        return $this->container['affected_views_per_hour_on_open'];
    }

    /**
     * Sets affected_views_per_hour_on_open
     *
     * @param int|null $affected_views_per_hour_on_open affected_views_per_hour_on_open
     *
     * @return self
     */
    public function setAffectedViewsPerHourOnOpen($affected_views_per_hour_on_open)
    {

        if (is_null($affected_views_per_hour_on_open)) {
            throw new \InvalidArgumentException('non-nullable affected_views_per_hour_on_open cannot be null');
        }

        $this->container['affected_views_per_hour_on_open'] = $affected_views_per_hour_on_open;

        return $this;
    }

    /**
     * Gets affected_views_per_hour
     *
     * @return int|null
     */
    public function getAffectedViewsPerHour()
    {
        return $this->container['affected_views_per_hour'];
    }

    /**
     * Sets affected_views_per_hour
     *
     * @param int|null $affected_views_per_hour affected_views_per_hour
     *
     * @return self
     */
    public function setAffectedViewsPerHour($affected_views_per_hour)
    {

        if (is_null($affected_views_per_hour)) {
            throw new \InvalidArgumentException('non-nullable affected_views_per_hour cannot be null');
        }

        $this->container['affected_views_per_hour'] = $affected_views_per_hour;

        return $this;
    }

    /**
     * Gets affected_views
     *
     * @return int|null
     */
    public function getAffectedViews()
    {
        return $this->container['affected_views'];
    }

    /**
     * Sets affected_views
     *
     * @param int|null $affected_views affected_views
     *
     * @return self
     */
    public function setAffectedViews($affected_views)
    {

        if (is_null($affected_views)) {
            throw new \InvalidArgumentException('non-nullable affected_views cannot be null');
        }

        $this->container['affected_views'] = $affected_views;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString(): string
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue(): string
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


